(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     34204,       1029]
NotebookOptionsPosition[     30981,        932]
NotebookOutlinePosition[     31422,        950]
CellTagsIndexPosition[     31379,        947]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Maksutov Camera", "Title"],

Cell[CellGroupData[{

Cell["Main function", "Subsection"],

Cell[TextData[StyleBox["MaksutovCamera",
 FontWeight->"Bold",
 FontVariations->{"Underline"->True}]], "Text"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Input variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["f1",
           FontWeight->Bold], Cell["focal length of the primary mirror"]},
         {Cell["diam",
           FontWeight->Bold], Cell["diameter of the primary mirror"]},
         {Cell["\[Theta]",
           FontWeight->Bold], Cell["field angle in degrees"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Optional arguments\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["OutputType", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], "\[SpanFromLeft]"},
         {"\[SpanFromAbove]", Cell["Report"], Cell["\<\
generates a report as a new notebook, that can be saved in many formats, for \
instance PDF\
\>"]},
         {"\[SpanFromAbove]", Cell["Print"], Cell["\<\
prints results in the current position of the evaluating notebook\
\>"]},
         {"\[SpanFromAbove]", Cell["Basic"], Cell["\<\
returns the list of pairs, with the short description of the output and the \
corresponding value\
\>"]},
         {"\[SpanFromAbove]", Cell["Values"], Cell[
          "returns only the list of output values, no descriptions"]},
         {Cell["OutputLevel", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], Cell[""]},
         {"\[SpanFromAbove]", Cell["Full"], Cell[
          "gives both input parameters and output values"]},
         {"\[SpanFromAbove]", Cell["Minimal"], Cell[
          "gives only output values"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interface function", "Subsection"],

Cell[TextData[{
 StyleBox["MaksutovCameraInputPanel",
  FontWeight->"Bold",
  FontVariations->{"Underline"->True}],
 " (no argument required, it creates a panel to work with the main function \
by means of easy controls and input fields)"
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Auxiliary function", "Subsection"],

Cell[TextData[StyleBox["TotalAberrations",
 FontWeight->"Bold",
 FontVariations->{"Underline"->True}]], "Text"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Input variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["rad",
           FontWeight->Bold], Cell["list of the radii of the surfaces"]},
         {Cell["thick",
           FontWeight->Bold], Cell["\<\
list of the distances between the surfaces along the optical axis\
\>"]},
         {Cell["ind",
           FontWeight->Bold], Cell["list of the refractive indices"]},
         {Cell["costasf",
           FontWeight->Bold], 
          TagBox[GridBox[{
             {"\<\"list of the constants which characterize the nature of any \
surface\"\>"},
             {"\<\"(0 for a sphere, K for a conic, {a4, as} for an aspheric \
surface)\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {Cell["stoprad",
           FontWeight->Bold], Cell["radius of the aperture stop"]},
         {Cell["nstop",
           FontWeight->Bold], Cell["number of the surfaces before the stop"]},
         {Cell["dis",
           FontWeight->Bold], 
          TagBox[GridBox[{
             {"\<\"if nstop = 0, is the (negative) distance of the aperture \
stop from the first surface after it\"\>"},
             {"\<\"if nstop > 0,  is the distance between the last surface \
before the aperture stop and the aperture stop\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {Cell["dobject",
           FontWeight->Bold], Cell[
          "distance of the object from the first surface"]},
         {Cell["hobject",
           FontWeight->Bold], Cell["\<\
height of the object (only if the object is at a finite distance)\
\>"]},
         {Cell["angle",
           FontWeight->Bold], Cell[
          "view angle in degrees (if the object is at infinity)"]},
         {Cell["waves",
           FontWeight->Bold], Cell[
          "the wavelengths of the chosen refractive indices"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Optional arguments\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["OutputType", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], "\[SpanFromLeft]"},
         {"\[SpanFromAbove]", Cell["Report"], Cell["\<\
generates a report as a new notebook, that can be saved in many formats, for \
instance PDF\
\>"]},
         {"\[SpanFromAbove]", Cell["Print"], Cell["\<\
prints results in the current position of the evaluating notebook\
\>"]},
         {"\[SpanFromAbove]", Cell["Basic"], Cell["\<\
returns the list of pairs, with the short description of the output and the \
corresponding value\
\>"]},
         {"\[SpanFromAbove]", Cell["Values"], Cell[
          "returns only the list of output values, no descriptions"]},
         {Cell["OutputLevel", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], Cell[""]},
         {"\[SpanFromAbove]", Cell["Full"], Cell[
          "gives both input parameters and output values"]},
         {"\[SpanFromAbove]", Cell["Minimal"], Cell[
          "gives only output values"]},
         {"\[SpanFromAbove]", Cell["Coefficients"], Cell[
          "gives only aberration coefficients"]},
         {"\[SpanFromAbove]", Cell["None"], Cell["doesn't show any result"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Output variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["GOn",
           FontWeight->Bold], Cell["Number of surface"]},
         {Cell["GOren",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Radius of the entrance pupil for \"",SubscriptBox[
            "\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOwen",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Distance of the exit pupil from the last surface for \"",
            SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOrexit",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Radius of the exit pupil for \"",SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOdistancefp",
           FontWeight->Bold], Cell[
          "Distance of the first principal plane from the first surface"]},
         {Cell["GOdistancesp",
           FontWeight->Bold], Cell[
          "Distance of the second principal plane from the last surface"]},
         {Cell["GOdistancegauss",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Gaussian distance of the images from the surface for \"",
            SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOfocalLength",
           FontWeight->Bold], Cell["Focal length"]},
         {Cell["GOimageHeight",
           FontWeight->Bold], Cell["Image height"]},
         {Cell["GOaberration",
           FontWeight->Bold], Cell["Third-order spherical aberration "]},
         {Cell["GOcoma",
           FontWeight->Bold], Cell["Third-order coma"]},
         {Cell["GOastigmatism",
           FontWeight->Bold], Cell["Third-order astigmatism"]},
         {Cell["GOcurvature",
           FontWeight->Bold], Cell["Third-order total curvature"]},
         {Cell["GOSeidelCurvature",
           FontWeight->Bold], Cell["Third-order curvature coefficient"]},
         {Cell["GOPetzvalRadius",
           FontWeight->Bold], Cell["Petzval radius"]},
         {Cell["GOdistortion",
           FontWeight->Bold], Cell["Third-order distortion"]},
         {Cell["GOSphericalCoefficient",
           FontWeight->Bold], Cell["Spherical Coefficient"]},
         {Cell["GOComaCoefficient",
           FontWeight->Bold], Cell["Coma Coefficient"]},
         {Cell["GOAstigmatismCoefficient",
           FontWeight->Bold], Cell["Astigmatism Coefficient"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Design of Maksutov Camera", "Title"],

Cell[TextData[{
 "The analysis of  the Maksutov Camera starts from the evaluation of the \
aberrations of a spherical mirror ",
 Cell[BoxData[
  FormBox["S", TraditionalForm]]],
 ", with a focal length ",
 Cell[BoxData[
  FormBox["\[ScriptF]", TraditionalForm]]],
 " and the aperture stop ",
 Cell[BoxData[
  FormBox["A", TraditionalForm]]],
 " placed in front of ",
 Cell[BoxData[
  FormBox["S", TraditionalForm]]],
 " at a distance  ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Dash]", 
    RowBox[{"\[Delta]", " ", "\[ScriptF]"}]}], TraditionalForm]]],
 ".   The meniscus, having radii R1 and R2,  is located at \[CapitalAlpha]. \
The system which is obtained by imposing that the spherical aberration, coma, \
and chromatism vanish, although algebraic, is difficult to solve even with \
Mathematica. Consequently, we first evaluate the spherical aberration and \
coma of the principal mirror, with the aperture stop \[CapitalAlpha] at a \
distance \[Dash]\[Delta]f and then we determine the corresponding quantities \
for the meniscus. The approximate values of the unkowns R1 and \[Delta] are \
obtained by requiring that the spherical aberration and coma of S and M are \
equal and opposite. The radius R2 is obtained by requiring that the first \
derivative of the focal length of M with respect to the refractive index \
vanishes. We note that evaluating separately the aberrations of the meniscus \
and the mirror is not quite appropriate since:"
}], "Text"],

Cell["the meniscus has necessarily a finite thikcness;", "Item"],

Cell["the meniscus focal is high but not infinity.", "Item"],

Cell["\<\
If all the lengths are referred to the focal f of the mirror S, the object is \
supposed at infinity (this hypothesis is not exactly thrue since the focal of \
the meniscus is finite), and the aperture stop is placed at a distance \
\[Dash]\[Delta] f from S, the coefficient of spherical aberration and coma of \
S are as follows. (the variables f, r, \[Delta], x, \[Theta], \[Lambda] have \
to be unassigned, for that we use Clear)\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "f", ",", "r", ",", "\[Delta]", ",", "x", ",", "\[Theta]", ",", 
    "\[Lambda]"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], "f"}], "}"}], ",", 
   RowBox[{"{", "0", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}]}], "}"}], "}"}], ",", 
   RowBox[{"{", "0", "}"}], ",", "r", ",", "0", ",", 
   RowBox[{
    RowBox[{"-", "\[Delta]"}], " ", "f"}], ",", 
   RowBox[{"-", "Infinity"}], ",", "x", ",", "\[Theta]", ",", 
   RowBox[{"{", "\[Lambda]", "}"}]}], "]"}]}], "Input"],

Cell["\<\
where the spherical coefficient, coma and astigmatism coefficients are given \
by the output variables\
\>", "Text"],

Cell[BoxData[
 RowBox[{"DS1", "=", "GOSphericalCoefficient"}]], "Input"],

Cell[BoxData[
 RowBox[{"DS2", "=", "GOComaCoefficient"}]], "Input"],

Cell[BoxData["GOAstigmatismCoefficient"], "Input"],

Cell["Similarly, for the meniscus we have:", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "R1", ",", " ", "s", ",", " ", "\[CapitalDelta]", ",", " ", "Ni", ",", "r",
     ",", "x", ",", "\[Theta]", ",", "\[Lambda]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"R1", ",", 
     RowBox[{"R1", "-", "s"}]}], "}"}], ",", 
   RowBox[{"{", "\[CapitalDelta]", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"1", ",", "Ni", ",", "1"}], "}"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], ",", "r", ",", "0", ",", "0", ",", 
   RowBox[{"-", "Infinity"}], ",", "x", ",", "\[Theta]", ",", 
   RowBox[{"{", "\[Lambda]", "}"}]}], "]"}]}], "Input"],

Cell["\<\
where the spherical coefficient, the coma coefficient and the astigmatism \
coefficient are given by the output variables\
\>", "Text"],

Cell[BoxData[
 RowBox[{"DM1", "=", "GOSphericalCoefficient"}]], "Input"],

Cell[BoxData[
 RowBox[{"DM2", "=", "GOComaCoefficient"}]], "Input"],

Cell[BoxData["GOAstigmatismCoefficient"], "Input"],

Cell["\<\
The first objective is to make achromatic the meniscus by requiring that the \
derivative of the focal length with respect to the refractive index vanishes. \
The focal lenght of M is\
\>", "Text"],

Cell[BoxData[
 RowBox[{"fcorr", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"GOfocalLength", "[", 
    RowBox[{"[", "1", "]"}], "]"}], "]"}]}]], "Input"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq2", "=", 
   RowBox[{
    RowBox[{"Together", "[", 
     RowBox[{"D", "[", 
      RowBox[{"fcorr", ",", "Ni"}], "]"}], "]"}], "//", "Numerator"}]}], 
  ";"}], "\n", 
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"eq2", "\[Equal]", "0"}], ",", "s"}], "]"}]}], "Input"],

Cell["\<\
The coefficient 0.97 of the formula proposed by Maksutov allows us to have \
the same focal length of red and blue light for rays at a distance 0.7r-0.8 r \
from the optical axis.\
\>", "Text"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"s", "\[Rule]", "R1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", "\[Rule]", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "\[CapitalDelta]"}], "+", 
       RowBox[{
        SuperscriptBox["Ni", "2"], " ", "\[CapitalDelta]"}]}], 
      SuperscriptBox["Ni", "2"]]}], "}"}]}], "}"}]], "DisplayFormula"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "Ni"}], ")"}], "2"], " ", "R1", " ", 
    SuperscriptBox["\[CapitalDelta]", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["Ni", "2"], " ", 
       RowBox[{"(", 
        RowBox[{"R1", "-", "\[CapitalDelta]"}], ")"}]}], "+", 
      "\[CapitalDelta]"}], ")"}]}], 
   SuperscriptBox["Ni", "4"]]}]], "DisplayFormula"],

Cell["\<\
It is interesting to analyze the value of s obtained by imposing that the \
back focals of the meniscus for red and blue light coincide (it is possible \
to prove that this condition is not modified by considering the mirror )\
\>", "Text",
 PageWidth->WindowWidth],

Cell[BoxData[{
 RowBox[{
  RowBox[{"eq2", "=", 
   RowBox[{
    RowBox[{"Together", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"GOdistancegauss", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "2"}], "]"}], "]"}], ")"}], "/.", 
        RowBox[{"Ni", "\[Rule]", "Nb"}]}], ")"}], "-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"GOdistancegauss", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "2"}], "]"}], "]"}], ")"}], "/.", 
        RowBox[{"Ni", "\[Rule]", "Nr"}]}], ")"}]}], "]"}], "//", 
    "Numerator"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"s1", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"eq2", "\[Equal]", "0"}], ",", "s"}], "]"}], "//", 
   "Flatten"}]}]}], "Input"],

Cell["\<\
 Now we consider the solution s as a function of the radius R1, assuming that \
its thickness \[CapitalDelta] is D/10 \
\>", "Text"],

Cell[BoxData[
 RowBox[{"bf", "=", 
  RowBox[{
   RowBox[{"s1", "[", 
    RowBox[{"[", 
     RowBox[{"2", ",", "2"}], "]"}], "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[CapitalDelta]", "\[Rule]", 
      RowBox[{"0.1", " ", "A"}]}], ",", 
     RowBox[{"Nb", "->", "1.5222376"}], ",", 
     RowBox[{"Nr", "->", "1.514322"}]}], "}"}]}]}]], "Input"],

Cell["\<\
We compare the plot of this function with the value of s given by Maksutov's \
formula which depens only on A, for instance when A=1/3, \
\>", "Text"],

Cell[BoxData[
 RowBox[{"pl", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"bf", "/.", 
       RowBox[{"{", 
        RowBox[{"A", "\[Rule]", 
         RowBox[{"1", "/", "3"}]}], "}"}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["Ni", "2"]}], ")"}], "0.1", "A"}], 
        SuperscriptBox["Ni", "2"]], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"A", "->", 
          RowBox[{"1", "/", "3"}]}], ",", 
         RowBox[{"Ni", "->", "1.5187228"}]}], "}"}]}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"R1", ",", 
      RowBox[{"-", "0.5"}], ",", 
      RowBox[{"-", "0.4"}]}], "}"}], ",", 
    RowBox[{"AxesOrigin", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.5"}], ",", "0.5"}], "}"}]}]}], "]"}]}]], "Input"],

Cell["\<\
In order to eliminate the spherical aberration, it is convenient to refer all \
the lengths to the focal f. In particular, we write\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a1", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"Numerator", "[", 
       RowBox[{"Together", "[", 
        RowBox[{"DM1", "+", "DS1"}], "]"}], "]"}], ")"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"R1", "\[Rule]", 
        RowBox[{"R1", " ", "f"}]}], ",", 
       RowBox[{"s", "\[Rule]", 
        RowBox[{"s", " ", "f"}]}], ",", 
       RowBox[{"\[CapitalDelta]", "\[Rule]", 
        RowBox[{"0.1", " ", "A", " ", "f"}]}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"b1", "=", 
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{
     FractionBox["1", 
      SuperscriptBox["f", "7"]], 
     RowBox[{"(", 
      RowBox[{"a1", "/.", 
       RowBox[{"s", "\[Rule]", 
        RowBox[{"0.1", " ", "A", " ", 
         FractionBox[
          RowBox[{
           SuperscriptBox["Ni", "2"], "-", "1"}], 
          RowBox[{"0.97", 
           SuperscriptBox["Ni", "2"]}]]}]}]}], ")"}]}], "/.", 
    RowBox[{"Ni", "->", "1.5187228"}]}], "]"}]}]}], "Input"],

Cell["\<\
The equation b1=0 is an algebraic seventh-degree equation. Therefore, it \
admits seven roots for any aperture ratio A. For instance, for A=1/4, we have \
that\
\>", "Text"],

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"b1", "/.", 
      RowBox[{"A", "\[Rule]", 
       RowBox[{"(", 
        RowBox[{"1", "/", "4"}], ")"}]}]}], ")"}], "\[Equal]", "0"}], ",", 
   "R1"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"p1", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"b1", "/.", 
      RowBox[{"A", "\[Rule]", 
       RowBox[{"(", 
        RowBox[{"1", "/", "4"}], ")"}]}]}], ")"}], ",", 
    RowBox[{"{", 
     RowBox[{"R1", ",", 
      RowBox[{"-", "0.5"}], ",", "0.5"}], "}"}]}], "]"}]}]], "Input"],

Cell[TextData[{
 "Four roots are complex, one corresponds to a very low value of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["R", "1"], TraditionalForm]]],
 ", and the remaining two roots are acceptable. However,  a longer tube is \
associated with the positive root."
}], "Text"],

Cell[" Coma vanishes when", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"coma", "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"DM2", "+", "DS2"}], ")"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"f", "\[Rule]", "1"}], ",", 
        RowBox[{"\[CapitalDelta]", "\[Rule]", 
         RowBox[{"0.1", " ", "A"}]}], ",", 
        RowBox[{"s", "\[Rule]", 
         RowBox[{"0.1", " ", "A", 
          FractionBox[
           RowBox[{
            SuperscriptBox["Ni", "2"], "-", "1"}], 
           RowBox[{"0.97", 
            SuperscriptBox["Ni", "2"]}]]}]}]}], "}"}]}], ")"}], "/.", 
    RowBox[{"Ni", "\[Rule]", "1.5187228"}]}]}], ";"}], "\n", 
 RowBox[{"eq2", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Numerator", "[", 
      RowBox[{"Together", "[", "coma", "]"}], "]"}], "//", "N"}], ")"}], 
   "\[Equal]", "0"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"sc", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{"eq2", ",", "\[Delta]"}], "]"}], "//", "Flatten"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"sc", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "2"}], "]"}], "]"}], "/.", 
       RowBox[{"A", "\[Rule]", 
        RowBox[{"1", "/", "2"}]}]}], ")"}], ",", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"sc", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "2"}], "]"}], "]"}], "/.", 
       RowBox[{"A", "\[Rule]", 
        RowBox[{"1", "/", "3"}]}]}], ")"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"R1", ",", 
     RowBox[{"-", "0.5"}], ",", 
     RowBox[{"-", "0.4"}]}], "}"}]}], "]"}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MaksutovCamera Examples", "Title"],

Cell["\<\
To use the MaksutovCamera function you can either use directly the function \
MaksutovCamera[f1, diam, \[Theta]] or use the interactive panel created by \
calling the function MaksutovCameraInputPanel[]. It let\[CloseCurlyQuote]s \
you to set input values and then call the MaksutovCamera function. Moreover, \
it helps to load examples from the saved archives and set the output style.
Here are some examples\
\>", "Text"],

Cell["Maksutov Camera 200 F/4", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f1", "=", "800"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"diam", " ", "=", "200"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", " ", "=", "1.2"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "generates", " ", "a", " ", "new", " ", "notebook", " ", 
    "with", " ", "a", " ", "report", " ", "of", " ", 
    RowBox[{"input", "/", "output"}], " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"MaksutovCamera", "[", 
   RowBox[{"f1", ",", "diam", ",", "\[Theta]"}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "prints", " ", "a", " ", "table", " ", "with", " ", "the", 
    " ", "summary", " ", "of", " ", 
    RowBox[{"input", "/", "output"}], " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"MaksutovCamera", "[", 
   RowBox[{"f1", ",", "diam", ",", "\[Theta]", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Print\>\""}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "prints", " ", "a", " ", "table", " ", "with", " ", "only", 
    " ", "the", " ", "output", " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"MaksutovCamera", "[", 
   RowBox[{"f1", ",", "diam", ",", "\[Theta]", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Print\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Minimal\>\""}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"this", " ", "gives", " ", 
     RowBox[{"input", "/", "output"}], " ", "values", " ", "as", " ", "a", 
     " ", "Return", " ", "from", " ", "the", " ", "function"}], ",", " ", 
    RowBox[{
    "with", " ", "labels", " ", "for", " ", "each", " ", "variable"}]}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"MaksutovCamera", "[", 
   RowBox[{"f1", ",", "diam", ",", "\[Theta]", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Basic\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Full\>\""}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "this", " ", "gives", " ", "only", " ", "output", " ", "values", " ", 
     "as", " ", "a", " ", "Return", " ", "from", " ", "the", " ", 
     "function"}], ",", " ", 
    RowBox[{"with", " ", "no", " ", "labels", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"useful", " ", "for", " ", "cutting"}], "&"}], "pasting", " ",
        "operations"}], " "}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"MaksutovCamera", "[", 
   RowBox[{"f1", ",", "diam", ",", "\[Theta]", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Values\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Minimal\>\""}]}], "]"}]}]], "Input"],

Cell["Maksutov Camera 200 F/3.3", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f1", "=", "660"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"diam", " ", "=", "200"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", " ", "=", "1.5"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"MaksutovCamera", "[", 
  RowBox[{"f1", ",", "diam", ",", "\[Theta]"}], "]"}]], "Input"],

Cell["Maksutov Camera 200 F/3.17", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f1", "=", "620.4"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"diam", " ", "=", "200"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", " ", "=", "1"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"MaksutovCamera", "[", 
  RowBox[{"f1", ",", "diam", ",", "\[Theta]"}], "]"}]], "Input"],

Cell["Load examples from the archive using LoadExample ", "Text"],

Cell[BoxData[
 RowBox[{"LoadExample", "[", "\"\<MaksutovCamera\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"MaksutovCamera", "[", "]"}]], "Input"],

Cell["Use the GUI panel to have all parameters under control", "Text"],

Cell[BoxData[
 RowBox[{"MaksutovCameraInputPanel", "[", "]"}]], "Input"]
}, Open  ]]
},
WindowSize->{1904, 992},
WindowMargins->{{-8, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
TrackCellChangeTimes->False,
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (July 28, 2016)",
StyleDefinitions->"GeometricOptics.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 32, 0, 71, "Title"],
Cell[CellGroupData[{
Cell[636, 26, 35, 0, 43, "Subsection"],
Cell[674, 28, 109, 2, 46, "Text"],
Cell[786, 32, 1340, 36, 177, "Text"],
Cell[2129, 70, 2110, 53, 389, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4276, 128, 40, 0, 43, "Subsection"],
Cell[4319, 130, 250, 6, 46, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4606, 141, 40, 0, 43, "Subsection"],
Cell[4649, 143, 111, 2, 46, "Text"],
Cell[4763, 147, 3193, 83, 551, "Text"],
Cell[7959, 232, 2296, 56, 473, "Text"],
Cell[10258, 290, 3465, 89, 849, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13772, 385, 42, 0, 71, "Title"],
Cell[13817, 387, 1465, 31, 142, "Text"],
Cell[15285, 420, 64, 0, 26, "Item"],
Cell[15352, 422, 60, 0, 26, "Item"],
Cell[15415, 424, 456, 7, 70, "Text"],
Cell[15874, 433, 682, 20, 55, "Input"],
Cell[16559, 455, 126, 3, 46, "Text"],
Cell[16688, 460, 72, 1, 32, "Input"],
Cell[16763, 463, 67, 1, 32, "Input"],
Cell[16833, 466, 50, 0, 32, "Input"],
Cell[16886, 468, 52, 0, 46, "Text"],
Cell[16941, 470, 718, 19, 55, "Input"],
Cell[17662, 491, 145, 3, 46, "Text"],
Cell[17810, 496, 72, 1, 32, "Input"],
Cell[17885, 499, 67, 1, 32, "Input"],
Cell[17955, 502, 50, 0, 32, "Input"],
Cell[18008, 504, 207, 4, 46, "Text"],
Cell[18218, 510, 154, 4, 32, "Input"],
Cell[18375, 516, 305, 10, 55, "Input"],
Cell[18683, 528, 203, 4, 46, "Text"],
Cell[18889, 534, 382, 12, 46, "DisplayFormula"],
Cell[19274, 548, 499, 16, 46, "DisplayFormula"],
Cell[19776, 566, 275, 5, 46, "Text"],
Cell[20054, 573, 818, 26, 55, "Input"],
Cell[20875, 601, 142, 3, 46, "Text"],
Cell[21020, 606, 360, 11, 32, "Input"],
Cell[21383, 619, 160, 3, 46, "Text"],
Cell[21546, 624, 941, 31, 54, "Input"],
Cell[22490, 657, 155, 3, 46, "Text"],
Cell[22648, 662, 1056, 33, 76, "Input"],
Cell[23707, 697, 183, 4, 46, "Text"],
Cell[23893, 703, 261, 9, 32, "Input"],
Cell[24157, 714, 336, 11, 32, "Input"],
Cell[24496, 727, 281, 7, 46, "Text"],
Cell[24780, 736, 35, 0, 46, "Text"],
Cell[24818, 738, 862, 27, 78, "Input"],
Cell[25683, 767, 147, 4, 32, "Input"],
Cell[25833, 773, 655, 22, 32, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[26525, 800, 40, 0, 71, "Title"],
Cell[26568, 802, 433, 7, 94, "Text"],
Cell[27004, 811, 39, 0, 46, "Text"],
Cell[27046, 813, 198, 6, 77, "Input"],
Cell[27247, 821, 382, 9, 55, "Input"],
Cell[27632, 832, 434, 10, 55, "Input"],
Cell[28069, 844, 461, 10, 55, "Input"],
Cell[28533, 856, 611, 13, 55, "Input"],
Cell[29147, 871, 730, 17, 55, "Input"],
Cell[29880, 890, 41, 0, 46, "Text"],
Cell[29924, 892, 198, 6, 77, "Input"],
Cell[30125, 900, 111, 2, 32, "Input"],
Cell[30239, 904, 42, 0, 46, "Text"],
Cell[30284, 906, 198, 6, 77, "Input"],
Cell[30485, 914, 111, 2, 32, "Input"],
Cell[30599, 918, 65, 0, 46, "Text"],
Cell[30667, 920, 85, 1, 32, "Input"],
Cell[30755, 923, 62, 1, 32, "Input"],
Cell[30820, 926, 70, 0, 46, "Text"],
Cell[30893, 928, 72, 1, 32, "Input"]
}, Open  ]]
}
]
*)

